<?php
defined('ABSPATH') or die("Plugin-<a href='http://wp.vom-kuhberg.de'>Download</a>");
/**
  * Plugin Name:  GC_Anwesenheits-Kalender
  * Plugin URI:   https://wp.vom-kuhberg.de
  * Description:  Einbinden eines Google Calendar als Tabelle
  * Version:      2022-04-07
  * Author:       hoermann@vom-kuhberg.de 
  * Author URI:   https://github.com/hoeulm
**/
//error_reporting(E_ALL-E_NOTICE);
	$url_anw="anw.ics";

function tab_csvanw($a_csv,$filter,$weeks=4)
{
	$ret ="<link rel=stylesheet href='". WP_PLUGIN_URL . "/gc_anw/css/style.css' />";
	//$ret ="<link rel=stylesheet href='css/style.css' />";
	//$ret.="<table border='1' cellspacing='0' title='$filter'>";
	//foreach($a_csv as $s_csv){$a_td=explode(";",$s_csv); $ret.="<tr>"; foreach($a_td as $s_td){$ret.="<td>$s_td</td>";} $ret.="</tr>";}
	//$ret.="</table>";
	$weeknow=date("W");
	$ret.="<b>$filter</b><table class='gc_anw'; border='1' cellspacing='0'><tr><td title='KalenderWoche'>KW</td><td>Mo</td><td>Di</td><td>Mi</td><td>Do</td><td>Fr</td><td>Sa</td></tr>";
	for($iw=$weeknow;$iw<$weeknow+$weeks;$iw++)
	{
		$iwx=$iw%52;
		$ret.="<tr><td>$iwx</td>";
		for($id=1;$id<7;$id++)
		{
			$a="&nbsp;-";
			foreach($a_csv as $s_csv)
			{
				$a_cols=explode(";",$s_csv);
				if( ($a_cols[0]==$iwx) && ($a_cols[3]==$id) &&($a_cols[6])==$filter){$a="<span title='$a_cols[7]' class='gc_anwgt'>✔</span>";}
			}
			$ret.="<td>$a</td>";
		}
		$ret.="</tr>";
	}
	$ret.="</table>";
	return $ret;
}

function gc_anwesenheit($atts)
{
	$a_wt=["So","Mo","Di","Mi","Do","Fr","Sa"];
	$fncsv_anw=ABSPATH."/data/gc_anw.csv";
	$fileage_anw=date("U")-filemtime($fncsv_anw);
	$ret ="";
	$filter=$atts["filter"] or $filter="Claudia";
	$ret.="Fileage $fncsv_anw[$filter] = $fileage_anw sec<hr/>";
	if($fileage_anw<3600){	return tab_csvanw(file($fncsv_anw),$filter); }
	
	$url_anw=$atts["gc_lnk"] or $url_anw="https://calendar.google.com/calendar/ical/5796h0jc251ask0r0aajstf0bs%40group.calendar.google.com/public/basic.ics";
	$url_anw="anw.ics";
	$a_anw=file($url_anw);
	$ymdnow=date("Y-m-d");
	$row="";
	//$ret.="<table border=1 cellspacing=0 ><tr class='trhead'><td>Woche</td><td>wn</td><td>Begin</td><td>Ende</td><td>Name</td><td>UID</td></tr>";
	$a_csv=array();
	foreach($a_anw as $s_anw)
	{
		list($k,$v)=explode(":",trim($s_anw),2);
		if(($k=="BEGIN") & ($v=="VEVENT")){$row="";}
		if(($k=="END")   & ($v=="VEVENT"))
		{
		//	$ret.="\n<tr>$row</tr>");
			$row="";
			if($ymds>=$ymdnow){ $a_csv[]="$weekn;$ymds;$wtt;$wtn;$hms;$hme;$anw;$dmy;$ymde;$uid";}
			$ymds=""; $ymde=""; $anw=""; $hms=""; $hme=""; $wtt=""; $wtn=""; $dmy="";
		}
		if( $k=="DTSTART" )               {$d=strtotime($v); $ymds=date("Y-m-d",$d); $dmy=date("d. M. Y",$d); $hms=date("H:i",$d);$weekn=date("W",$d);$wtn=date("w",$d); $wtt=$a_wt[$wtn]; if($ymds>=$ymdnow){$c=" bgColor='lime'";} else{$c="";} $row.="<td$c>$wtt</td><td>$ymds $hms</td>";}
		if( $k=="DTSTART;VALUE=DATE")     {$d=strtotime($v); $ymds=date("Y-m-d",$d); $dmy=date("d. M. Y",$d); $hms="09:00";       $weekn=date("W",$d);$wtn=date("w",$d); $wtt=$a_wt[$wtn]; if($ymds>=$ymdnow){$c=" bgColor='lime'";} else{$c="";} $row.="<td$c>$wtt</td><td>$ymds $hms</td>";}
		if( $k=="DTEND;VALUE=DATE")       {$d=strtotime($v); $ymde=date("Y-m-d",$d); $hme="21:30";         $row.="<td>$hme</td>";}
		if( $k=="DTEND" )                 {$d=strtotime($v); $ymde=date("Y-m-d",$d); $hme=date("H:i",$d);  $row.="<td>$hme</td>";}
		if( $k=="SUMMARY" )               {$anw=$v; $row.="<td>$anw</td>";  }
		if( $k=="UID")                    {$uid=$v; $row.="<td>$uid</td>";}
	}
	//$ret.="</table>";
	sort($a_csv);
	$fhanw=fopen($fncsv_anw,"w");
	fputs($fhanw,"#KW;Datum;wt;wtn;von;bis;Person;dmy;ende;Id-GC\n");
	foreach($a_csv as $s_csv){fputs($fhanw,$s_csv."\n");}
	fclose($fhanw);
	return tab_csvanw($a_csv,$filter);
}
add_shortcode('GC_Anw','gc_anwesenheit');  // external Name, internal Name

?>