<?php
defined('ABSPATH') or die("Plugin-Download at <a href='wp.vom-kuhberg.de'>wp.vom-kuhberg.de</a>");
/**
  * Plugin Name:  sh-gorbatchev
  * Plugin URI:   http://wp.vom-kuhberg.de
  * Description:  Syntax Highlighter von Alex Gorbatchev
  * Version:      2019.05.30
  * Author:       Richard Hoermann
  * Author URI:   http://wp.vom-kuhberg.de
  * Usage:        shortcode [sh-gorbatchev source='hallowelt.cpp' brush='cpp' lnoff='1' css='Midnight' ]
**/  
function srctest()
{return array(
"void setup()\n",
"{\n",
"  Serial.begin(115200);\n",
"}\n",
"\n",
"void loop()\n",
"{\n",
"  Serial.println(analogRead(A0));\n",
"  delay(100); // Bewirkt ca 10 Messungen pro Sek\n",
"}");
}

function SH_GORBATSCHEV($atts)
{
	error_reporting(E_ALL-E_NOTICE);
	$sh_source=$atts['source'] or $sh_source="hw.ino";
	$sh_brush =$atts['brush']  or $sh_brush="ino";
	$sh_theme =$atts['theme']  or $sh_theme="MidNight";
	$sh_lnoff =$atts['lnoff']  or $sh_lnoff="1";  // Zeilennummern
	$sh_lnoff=$sh_lnoff*1;
	$sh_opt=""; 
	if($sh_lnoff>1){$sh_opt.=" first-line:$sh_lnoff;";}
	if($sh_lnoff<1){$sh_opt.=" gutter:false;";}
 	$plugin_url = plugin_dir_url( __FILE__ );
	wp_enqueue_style( 'shCore' , $plugin_url . '_css/shCore.css' );
	wp_enqueue_style( 'shTheme', $plugin_url . '_css/shTheme'.$sh_theme.'.css' );
	//wp_enqueue_script('shCore'        , $plugin_url . '_js/shCore.js' );
	//wp_enqueue_script('shBrush'       , $plugin_url . '_js/shBrush_$sh_brush.js' );
	if(file_exists("_src/$sh_source"))
			{$sh_lines = file("_src/$sh_source");} 
		else{$sh_lines=srctest();}
	$sh_cnt=sizeof($sh_lines);
	$ico=$sh_brush.".gif";
	$ret ="\n<script type='text/javascript' src='$plugin_url"."_js/shCore.js'></script>";
	$ret.="\n<script type='text/javascript' src='$plugin_url"."_js/shBrush_$sh_brush.js'></script>\n";
	$ret.="\n<script type='text/javascript'>SyntaxHighlighter.all();</script>";
	$ret.="\n<div id='syntaxhighlight'><img src='$plugin_url"."_img/$ico' />o=$sh_lnoff $sh_opt Quellcode von <b>$sh_source</b> mit $sh_cnt Zeilen";
	$ret.="\n<pre class='brush: $sh_brush; $sh_opt '>";
	foreach($sh_lines as $s){$sx=str_replace("<","&lt;",$s); $ret.=$sx; }
	$ret.="</pre></div>";
	return $ret;
}
add_shortcode('sh-gorbatchev','SH_GORBATSCHEV');  //external name for Shortcode, internal name in this source
?>