﻿var	i_valcnt=as_csv.length;		// Laenge des Wertearrays
var	i_dx=4;						// Abstand der Messpunkte in x
var i_valmax=1024/4;			// Werden mehr Punkte gezeichnet wird gescrollt!!
var	f_tcmax=-274;				// default Temp Celsius Max
var	f_tcmin=999;				// default Temp Celsius Min
var y1=256;						// default y Wert
var f_tcval=20.0;				// default wert Temperatur
var i_demo=-1;					// Id fuer Demomode
var b_demo=false;				// Demo Running ?

function h2(val)				// returns hex of val
{ vali=Math.floor(val);if (vali<16){return "0"+vali.toString(16);} return vali.toString(16);}

function val_to_y(val)			// Wandelt Messwert in y-Koordinate um!
{ return parseInt((f_val-5.0)/30.0*5120.0)/10.0;}

function cels_to_rgb(cels)		// Temperaturwert in Farbwert umwandeln!
{
	if (cels<=-20) {return "#FF00FF";}
	if (cels== 10) {return "#00FFFF";}
	if (cels<=-10) {return "#"+h2(-255*(cels+10)/10)+"00FF";   }
	if (cels<=  0) {return "#00"+h2(128-128*-cels/10)+"FF";    }
	if (cels<= 10) {return "#00"+h2(128+128*(cels/10))+"FF";   }
	if (cels<= 20) {return "#00FF"+h2(255-255*(cels-10)/10);   }
	if (cels<= 30) {return "#"+h2(255*(cels-20)/10)+"FF00";    }
	if (cels<= 40) {return "#FF"+h2(255-255*(cels-30)/10)+"00";}
	return "#FF0000";
}

function svg_oszi_info(idx)		// OnClick bei Messlinie bzw. Scrollbar
{
	document.getElementById('clipPathRect').setAttribute('width',idx);
	i=Math.floor(idx/i_dx);
	if(i<i_valcnt)
	{
		as_csvc=as_csv[i].split(";"); s_ts=as_csvc[0]; s_val=as_csvc[1];
		document.getElementById('celslast').innerHTML=s_val+"&deg;C";
		document.getElementById('celslastts').innerHTML=s_ts;
	}
}

function svg_oszi_minmax()		// Minimum un Maximum Wert ermitteln und ausgeben
{
	for(i=0;i<i_valcnt;i++)
	{
		as_csvc=as_csv[i].split(";"); s_ts=as_csvc[0]; s_val=as_csvc[1]; s_valx=s_val.replace(",",".");
		f_val=parseFloat(s_valx);
		if(f_val>f_tcmax){f_tcmax=f_val; s_tcmax=s_ts;}
		if(f_val<f_tcmin){f_tcmin=f_val; s_tcmin=s_ts;}
	}
	document.getElementById('celsmax').innerHTML = f_tcmax+" &deg;C";
	document.getElementById('celsmaxts').innerHTML = s_tcmax;
	document.getElementById('celslast').innerHTML = f_val+" &deg;C";
	document.getElementById('celslastts').innerHTML = s_ts;
	document.getElementById('celsmin').innerHTML = f_tcmin+" &deg;C";
	document.getElementById('celsmints').innerHTML = s_tcmin;
}

function svg_oszi()				// Grundgeruest des Oszis zeichnen
{
	document.write("<svg id='svo' width='100%' viewBox='-10 -522 1044 532' >");
	document.write("<rect x='-5' y='-517' width='1034' height='522' stroke='darkgray' stroke-width='5' fill='none' />");
	document.write("<rect x='0'  y='-512' width='1024' height='512' fill='black' />");
	document.write("<defs><clipPath id='clipPath' >");
	document.write("<rect id='clipPathRect' x='0' y='-512' width='1024' height='512'  /></clipPath>");
	document.write("</defs>");
	document.write("<g id='gitter' stroke='gray' stroke-width='0.5' stroke-dasharray='1 1' fill='none' >");
	document.write("<line x1='0'   y1='-64'  x2='1024' y2='-64'  /><line x1='0'   y1='-128' x2='1024' y2='-128' />");
	document.write("<line x1='0'   y1='-192' x2='1024' y2='-192' /><line x1='0'   y1='-256' x2='1024' y2='-256' />");
	document.write("<line x1='0'   y1='-320' x2='1024' y2='-320' /><line x1='0'   y1='-384' x2='1024' y2='-384' />");
	document.write("<line x1='0'   y1='-448' x2='1024' y2='-448' /><line x1='128' y1='0'    x2='128'  y2='-512' />");
	document.write("<line x1='256' y1='0'    x2='256'  y2='-512' /><line x1='384' y1='0'    x2='384'  y2='-512' />");
	document.write("<line x1='512' y1='0'    x2='512'  y2='-512' /><line x1='640' y1='0'    x2='640'  y2='-512' />");
	document.write("<line x1='768' y1='0'    x2='768'  y2='-512' /><line x1='896' y1='0'    x2='896'  y2='-512' />");
	document.write("</g>");
	document.write("<g id='LinesGroup' style='clip-path:url(#clipPath);'></g></svg>");
}

function svg_oszi_valadd(i,value)	// Dem Oszi eine Messwertlinie hinzufuegen 
{
	y2=val_to_y(value);
	s_rgb=cels_to_rgb(value);
	if (i<i_valmax)
	{   // NO SCROLLING => Add a new Line
		var svgo=document.getElementById('LinesGroup');
		var newline=document.createElementNS('http://www.w3.org/2000/svg',"line");
		var x1=i*i_dx; x2=x1+i_dx;
		if(i==0){y1=y2;}
		newline.setAttributeNS(null, "id", "li_"+i);
		newline.setAttributeNS(null, "x1", x1); newline.setAttributeNS(null, "y1", -y1);
		newline.setAttributeNS(null, "x2", x2); newline.setAttributeNS(null, "y2", -y2);
		newline.setAttributeNS(null, "stroke", s_rgb);
		newline.setAttributeNS(null, "stroke-width",3);
		newline.setAttributeNS(null, "fill", "none");
		svgo.appendChild(newline);
	}
	else
	{
		for(j=0;j<i-1;j++)
		{
			k=j+1;
			eij=document.getElementById('li_'+j);
			eik=document.getElementById('li_'+k);
			eij.setAttributeNS(null,'y1',eik.getAttribute('y1'));
			eij.setAttributeNS(null,'y2',eik.getAttribute('y2'));
			eij.setAttributeNS(null,'stroke',eik.getAttribute('stroke'));
		}
		y2=val_to_y(value);
		eik.setAttributeNS(null,'y1',-y1);
		eik.setAttributeNS(null,'y2',-y2);
		eik.setAttributeNS(null,'stroke',s_rgb);
	}
	y1=y2;
}

function svg_oszi_plot()			// Alle vorhandenen Messwerte zeichnen
{
	svg_oszi_minmax();
	for(i=0;i<i_valcnt;i++)
	{
		as_csvc=as_csv[i].split(";"); s_ts=as_csvc[0]; s_val=as_csvc[1];
		f_val=parseFloat(s_val.replace(",","."));
		c_val=cels_to_rgb(f_val);
		svg_oszi_valadd(i,f_val);
	}
}

function svg_oszi_vadd()            // Wert hinzufuegen 
{
	d=new Date(); var mo=d.getMonth()+1;
	s_ts=d.toISOString(); s_ts=s_ts.substring(0,19);
	s_val=document.getElementById('tcelsadd').value;
	s_new=s_ts+";"+s_val;
	f_vala=parseFloat(s_val.replace(",","."));
	if(i_valcnt<i_valmax)
		{as_csv.push(s_new); i_valcnt++; }
	else{for(i=0;i<i_valmax-1;i++){as_csv[i]=as_csv[i+1];}
			as_csv[i+1]=s_new; i_valcnt=i_valmax+1;}
	svg_oszi_minmax();
	svg_oszi_valadd(i_valcnt-1,f_vala); 
	r4=-1.99+4.0*Math.random();
	f_vala=parseInt((f_vala+r4)*10)/10.0;
	if((f_vala>34.5)|(f_vala<5.5)){f_vala=20;}
	document.getElementById('tcelsadd').value=f_vala;
}

function svg_oszi_refresh()			// Alle Linien Loeschen und neu zeichnen
{
	for(i=0;i<i_valcnt-1;i++)	{ document.getElementById('li_'+i).remove();}
	svg_oszi_plot();
}

function svg_oszi_demo()			// Demo Mode an/aus-schalten
{
	if(b_demo)
			{clearInterval(i_demo); b_demo=false;}
		else{i_demo=setInterval(svg_oszi_vadd,50); b_demo=true;}
}